


jQuery(  document ).ready( function( $ ){

    // Initialize Topbar Search.
    $( '.search-toggle' ).on( 'click', function(){
        var _this            = $( this );
        $( '.header-search' ).toggleClass( 'header-search-toggled-on' );
        _this.attr( 'aria-expanded', _this.attr( 'aria-expanded' ) === 'false' ? 'true' : 'false' );
    });


    function featuredPostsSlider(){
        $( '.featured-posts-slider' ).slick( {
            'rtl'            : ( jQuery( 'html' ).attr( 'dir' ) == 'rtl' ) ? true : false,
            'adaptiveHeight' : false,
            'autoplay'       : true,
            'autoplaySpeed'  : 5400,
            'cssEase'        : 'ease-in-out',
            'dots'           : false,
            'draggable'      : false,
            'easing'         : 'easeInOutBack',
            'fade'           : true,
            'pauseOnHover'   : true,
            'slide'          : 'article',
            'speed'          : 600,
            'swipeToSlide'   : true,
            'prevArrow'      : '<div class="slider-nav slider-nav-prev transition5"><button type="button" class="slick-prev"><i class="fa fa-angle-left"></i></button></div>',
            'nextArrow'      : '<div class="slider-nav slider-nav-next transition5"><button type="button" class="slick-next"><i class="fa fa-angle-right"></i></button></div>'
        } );
    }

    function testimonialsSlider(){
        $( '.testimonials-slider' ).slick( {
            'rtl'            : ( jQuery( 'html' ).attr( 'dir' ) == 'rtl' ) ? true : false,
            'adaptiveHeight' : false,
            'autoplay'       : true,
            'autoplaySpeed'  : 5400,
            'cssEase'        : 'ease-in-out',
            'dots'           : false,
            'draggable'      : false,
            'easing'         : 'easeInOutBack',
            'fade'           : true,
            'pauseOnHover'   : true,
            'slide'          : 'article',
            'speed'          : 600,
            'swipeToSlide'   : true,
            'prevArrow'      : '<div class="slider-nav slider-nav-prev transition5"><button type="button" class="slick-prev"><i class="fa fa-angle-left"></i></button></div>',
            'nextArrow'      : '<div class="slider-nav slider-nav-next transition5"><button type="button" class="slick-next"><i class="fa fa-angle-right"></i></button></div>'
        } );
    }

    // Initialize Featured Content & Testimonial Slider
    if ( $().slick ) {
        featuredPostsSlider();
        testimonialsSlider();
    }

    var isCustomizeSelectiveRefresh = ( 'undefined' !== typeof wp && wp.customize && wp.customize.selectiveRefresh );

    if ( isCustomizeSelectiveRefresh ) {
        wp.customize.selectiveRefresh.bind( 'partial-content-rendered', function( placement ) {
            if ( placement.partial.id == 'section-featured_content' ) {
                featuredPostsSlider();
            }
            if ( placement.partial.id == 'section-testimonials' ) {
                testimonialsSlider();
            }
            
        } );
    }

    

} );
