<?php
/**
 * Add customizer selective refresh
 *
 * @since 1.2.1
 *
 * @param $wp_customize
 */
function wellness_customizer_partials( $wp_customize )
{

    // Abort if selective refresh is not available.
    if ( ! isset( $wp_customize->selective_refresh ) ) {
        return;
    }

    $selective_refresh_keys = array(

        array(
            'id' => 'wellness_site_brand',
            'selector' => '#header-site-branding',
            'callback' => 'wellness_site_brand',
            'settings' => array(
                'custom_logo',
                'blogname',
                'blogdescription',
            ),
        ),

        // section features
        array(
            'id' => 'featured_content',
            'selector' => '#featured-content-area',
            'settings' => array(
                'featured_content_num_post',
                'featured-content[tag-name]',
                'featured-content[hide-tag]',
                'featured-content[show-all]',
            ),
        ),

        array(
            'id' => 'featured_pages',
            'selector' => '#featured-page-area',
            'settings' => array(
                'wellness_featured_page_one_front_page',
                'wellness_featured_page_two_front_page',
                'wellness_featured_page_three_front_page',
            ),
        ),

        array(
            'id' => 'grid_pages',
            'selector' => '#grid-page-area',
            'settings' => array(
                'wellness_grid_page',
                'wellness_number_child_pages',
                'wellness_grid_page_section_title',
                'wellness_grid_page_section_desc',
            ),
        ),

        array(
            'id' => 'testimonials',
            'selector' => '#testimonials-area',
            'settings' => array(
                'wellness_testimonial_section_title',
                'wellness_testimonial_layout_front_page',
            ),
        ),

        array(
            'id' => 'latest_news',
            'selector' => '#latest-news-area',
            'settings' => array(
                'wellness_latest_news_section',
                'wellness_latest_news_section_title',
            ),
        ),

    );

   

    $selective_refresh_keys = apply_filters( 'wellness_customizer_selective_refresh_sections', $selective_refresh_keys );

    foreach ( $selective_refresh_keys as $section ) {
        if ( $section['id'] ) {
            foreach ($section['settings'] as $index => $key) {
                if ($wp_customize->get_setting($key)) {
                    $wp_customize->get_setting($key)->transport = 'postMessage';
                } else {
                    // remove not existing setting
                    unset( $section['settings'][ $index ] );
                }
            }

            $func_name = isset( $section['callback'] ) ? $section['callback']: 'wellness_selective_refresh_render_section_content';
            $selector = isset( $section['selector']  ) ? $section['selector'] : 'section.section-' . $section['id'] ;

            $wp_customize->selective_refresh->add_partial('section-' . $section['id'], array(
                'selector' => $selector,
                'settings' => $section['settings'],
                'render_callback' => $func_name,
            ));

        }
    }

    // Custom Selective refresh
    $custom_css = array(
        'primary_color',
        'header_text_color',
    );
    foreach ( $custom_css as $index => $key ) {
        if ( $wp_customize->get_setting( $key ) ) {
           $wp_customize->get_setting( $key )->transport = 'postMessage';
        } else {
           unset( $custom_css[ $index ] );
        }
    }

    /**
     * @see wellness_custom_style
     */
    $wp_customize->selective_refresh->add_partial( 'custom_style' , array(
        'selector' => '#wellness-style-inline-css',
        'settings' => $custom_css,
        'render_callback' => 'wellness_custom_style',
    ));

}
add_action( 'customize_register', 'wellness_customizer_partials', 95 );

/**
 * Selective render content
 *
 * @param $partial
 * @param array $container_context
 */
function wellness_selective_refresh_render_section_content( $partial, $container_context = array() ) {
    $GLOBALS['wellness_is_selective_refresh'] = true;
    $id = $partial->id;
    $id = str_replace( 'section-', '', $id );
    do_action( 'wellness_selective_refresh_before_render_section_content', $partial, $container_context );
    if ( $id ) {
        $function = 'wellness_'.$id.'_section' ;
        $hook = 'wellness_font_page_section_'.$id;
        if ( function_exists( $function ) ) {
            add_action( $hook, $function );
        }
        do_action( $hook );
    }
    do_action( 'wellness_selective_refresh_after_render_section_content', $partial, $container_context );
}