<?php
/**
 * Wellness Theme Customizer.
 *
 * @package Wellness
 */


/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function wellness_customize_register( $wp_customize ) {

    $wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';

    // Remove header tagline settings
    $wp_customize->remove_control( 'header_text' );
    $wp_customize->remove_setting( 'header_text' );


    // Load custom controls
    require get_template_directory() . '/inc/customizer-controls.php';

    // Load custom sections.
    require get_template_directory() . '/inc/customizer-sections.php';

    // Register custom section types.
    $wp_customize->register_section_type( 'Wellness_Customize_Section_Premium' );


    $wp_customize->add_setting( 'show_site_title', array(
        'default'           => '1',
        'sanitize_callback' => 'wellness_sanitize_checkbox',
    ) );
    $wp_customize->add_control( 'show_site_title', array(
        'label'             => esc_html__( 'Display site title', 'wellness' ),
        'section'           => 'title_tagline',
        'priority'          => 20,
        'type'              => 'checkbox',
    ) );

    $wp_customize->add_setting( 'show_site_tagline', array(
        'default'           => '',
        'sanitize_callback' => 'wellness_sanitize_checkbox',
    ) );
    $wp_customize->add_control( 'show_site_tagline', array(
        'label'             => esc_html__( 'Display site tagline', 'wellness' ),
        'section'           => 'title_tagline',
        'priority'          => 21,
        'type'              => 'checkbox',
    ) );


	$wp_customize->add_panel( 'wellness_theme_options', array(
		'title'    => __( 'Theme Options', 'wellness' ),
		'priority' => 205,
	) );

	/* Front Page Template: Featured Pages Section */
   
        $number = 3;
        $featured_desc = sprintf( esc_html__( 'This section is designed to display up to 3 featured posts on the Front Page Template. Upgrade to 6 posts.', 'wellness' ), '<a target="_blank" href="'.wellness_get_premium_url().'">'.esc_html__( 'Premium', 'wellness' ).'</a>' );
    

	$wp_customize->add_section( 'wellness_featured_pages_section' ,
		array(
			'panel'       => 'wellness_theme_options',
            'priority'    => 20,
			'title'       => esc_html__( 'Front Page: Features Pages Section', 'wellness' ),
			'description' => $featured_desc,
            'active_callback' => 'wellness_is_frontpage'
		)
	);

    for (  $i = 1; $i<= $number; $i ++ ) {

        $t = wellness_n2t( $i );
        /* Featured Page One */
        $wp_customize->add_setting( 'wellness_featured_page_'.$t.'_front_page', array(
            'default'           => 0,
            'sanitize_callback' => 'wellness_sanitize_dropdown_pages',
        ) );
        $wp_customize->add_control( 'wellness_featured_page_'.$t.'_front_page', array(
            'label'             => sprintf( esc_html__( 'Featured Page #%s', 'wellness' ), $i ),
            'section'           => 'wellness_featured_pages_section',
            'priority'          => 5 + $i,
            'type'              => 'dropdown-pages',
        ) );

    }


	/* Front Page Template: Grid Pages Section */
	$wp_customize->add_section( 'wellness_grid_page_section' ,
		array(
			'panel'       => 'wellness_theme_options',
            'priority'    => 25,
			'title'       => esc_html__( 'Front Page: Grid Page Section', 'wellness' ),
			'description' => esc_html__( 'This section is designed to display a grid layout of pages on the Front Page Template, you need to select a page that has child pages. Please note only child pages width featured image will be displayed.', 'wellness' ),
            'active_callback' => 'wellness_is_frontpage'
		)
	);
		/* Grid Page page */
		$wp_customize->add_setting( 'wellness_grid_page', array(
			'default'           => '',
			'sanitize_callback' => 'wellness_sanitize_dropdown_pages',
		) );
		$wp_customize->add_control( 'wellness_grid_page', array(
			'label'             => esc_html__( 'Select Page', 'wellness' ),
			'section'           => 'wellness_grid_page_section',
			'priority'          => 5,
			'type'              => 'dropdown-pages',
		) );

		/* Number of child page to show */
		$wp_customize->add_setting( 'wellness_number_child_pages', array(
			'default'           => '6',
			'sanitize_callback' => 'wellness_sanitize_number_absint',
		) );
		$wp_customize->add_control( 'wellness_number_child_pages', array(
			'label'             => esc_html__( 'Number of child pages to show', 'wellness' ),
			'section'           => 'wellness_grid_page_section',
			'priority'          => 7,
		) );

		/* Custom Section Title */
		$wp_customize->add_setting( 'wellness_grid_page_section_title', array(
			'default'           => '',
			'sanitize_callback' => 'wellness_sanitize_text',
		) );
		$wp_customize->add_control( 'wellness_grid_page_section_title', array(
			'label'             => esc_html__( 'Custom section title', 'wellness' ),
			'section'           => 'wellness_grid_page_section',
			'priority'          => 9,
			'description'		=> esc_html__( 'If empty, the title of the page you selected above will be use instead.', 'wellness' )
		) );

		/* Custom Section Description */
		$wp_customize->add_setting( 'wellness_grid_page_section_desc', array(
			'default'           => '',
			'sanitize_callback' => 'wellness_sanitize_html',
		) );
		$wp_customize->add_control( 'wellness_grid_page_section_desc', array(
			'label'             => esc_html__( 'Custom section description', 'wellness' ),
			'section'           => 'wellness_grid_page_section',
			'priority'          => 11,
			'type'     			=> 'textarea'
		) );

	/* Front Page Template: Testimonial Section */
	$wp_customize->add_section( 'wellness_testimonial_section' ,
		array(
			'panel'       => 'wellness_theme_options',
            'priority'    => 35,
			'title'       => esc_html__( 'Front Page: Testimonial Section', 'wellness' ),
            'active_callback' => 'wellness_is_frontpage'
		)
	);

		/* Show Testimonial */
		$wp_customize->add_setting( 'wellness_testimonial_on_frontpage', array(
			'default'           => '',
			'sanitize_callback' => 'wellness_sanitize_checkbox',
		) );
		$wp_customize->add_control( 'wellness_testimonial_on_frontpage', array(
			'label'             => esc_html__( 'Display Testimonials', 'wellness' ),
			'section'           => 'wellness_testimonial_section',
			'priority'          => 5,
			'type'              => 'checkbox',
			'description'		=> esc_html__( 'If left checked then four random testimonials will be display on the Front Page template.', 'wellness' ),
		) );

		/* Custom Section Title */
		$wp_customize->add_setting( 'wellness_testimonial_section_title', array(
			'default'           => esc_html__('Our Happy Clients', 'wellness'),
			'sanitize_callback' => 'wellness_sanitize_text',
		) );
		$wp_customize->add_control( 'wellness_testimonial_section_title', array(
			'label'             => esc_html__( 'Testimonial section title', 'wellness' ),
			'section'           => 'wellness_testimonial_section',
			'priority'          => 7,
		) );

		/* Number of testimonial to show */
		$wp_customize->add_setting( 'wellness_number_testimonials', array(
			'default'           => 4,
			'sanitize_callback' => 'wellness_sanitize_number_absint',
		) );
		$wp_customize->add_control( 'wellness_number_testimonials', array(
			'label'             => esc_html__( 'Number of testimonial to show', 'wellness' ),
			'section'           => 'wellness_testimonial_section',
			'priority'          => 7,
		) );

		/* Front page testimonials layout */
		$wp_customize->add_setting( 'wellness_testimonial_layout_front_page', array(
			'default'           => 'slider',
			'sanitize_callback' => 'wellness_sanitize_front_page_testimonial_layout',
		) );
		$wp_customize->add_control( 'wellness_testimonial_layout_front_page', array(
			'label'             => esc_html__( 'Testimonials Layout', 'wellness' ),
			'section'           => 'wellness_testimonial_section',
			'priority'          => 9,
			'type'              => 'radio',
			'description'		=> esc_html__( 'Choose the testimonial layout on Front Page template.', 'wellness' ),
			'choices'           => array(
				'slider' => esc_html__( 'Slider', 'wellness' ),
				'grid'   => esc_html__( 'Grid', 'wellness' ),
			),
		) );

	/* Front Page Template: Latest News Section */
	$wp_customize->add_section( 'wellness_latest_news_section' ,
		array(
			'panel'       => 'wellness_theme_options',
            'priority'    => 85,
			'title'       => esc_html__( 'Front Page: Latest News Section', 'wellness' ),
            'active_callback' => 'wellness_is_frontpage'
		)
	);

		/* Show Latest News */
		$wp_customize->add_setting( 'wellness_latest_news_on_frontpage', array(
			'default'           => '1',
			'sanitize_callback' => 'wellness_sanitize_checkbox',
		) );
		$wp_customize->add_control( 'wellness_latest_news_on_frontpage', array(
			'label'             => esc_html__( 'Display latest news section', 'wellness' ),
			'section'           => 'wellness_latest_news_section',
			'priority'          => 5,
			'type'              => 'checkbox',
			'description'		=> esc_html__( 'If left checked then four latest posts will be display in a grid layout on the Front Page template.', 'wellness' ),
		) );
		/* Custom Section Title */
		$wp_customize->add_setting( 'wellness_latest_news_section_title', array(
			'default'           => esc_html__('Latest News & Updates', 'wellness'),
			'sanitize_callback' => 'wellness_sanitize_text',
		) );
		$wp_customize->add_control( 'wellness_latest_news_section_title', array(
			'label'             => esc_html__( 'Latest news section title', 'wellness' ),
			'section'           => 'wellness_latest_news_section',
			'priority'          => 7,
		) );

	/* General Settings */
	$wp_customize->add_section( 'wellness_general_options' ,
		array(
			'panel'       => 'wellness_theme_options',
			'title'       => esc_html__( 'General Settings', 'wellness' ),
            'priority'    => 10,
		)
	);
		/* Sidebar Position */
		$wp_customize->add_setting( 'wellness_sidebar_position', array(
			'default'           => 'right',
			'sanitize_callback' => 'wellness_sanitize_sidebar_position',
		) );
		$wp_customize->add_control( 'wellness_sidebar_position', array(
			'label'             => esc_html__( 'Sidebar Position', 'wellness' ),
			'section'           => 'wellness_general_options',
			'priority'          => 2,
			'type'              => 'radio',
			'choices'           => array(
				'left'  => __( 'Left', 'wellness' ),
				'right' => __( 'Right', 'wellness' ),
			),
		) );

		// Sticky Menu


        $wp_customize->add_setting( 'header_text_color',
            array(
                'sanitize_callback' => 'sanitize_hex_color_no_hash',
                'sanitize_js_callback' => 'maybe_hash_hex_color',
                'default' => '42caad'
            ) );
        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'header_text_color',
            array(
                'label'       => esc_html__( 'Header text color', 'wellness' ),
                'section'     => 'colors',
                'description' => '',
                'priority'    => 6,
            )
        ));

         // end if premium
            // Premium footer

            $wp_customize->add_setting( 'footer_copyright_editor_message',
                array(
                    'sanitize_callback' => 'sanitize_text_field',
                    'default'           => '',
                )
            );
            $wp_customize->add_control( new Wellness_Group_Settings_Heading_Control( $wp_customize, 'footer_copyright_editor_message',
                    array(
                        'type'        => 'group_heading_message',
                        'title'       => esc_html__('Change Footer Copyright Text and Hide Theme Author Link', 'wellness'),
                        'section'     => 'wellness_general_options',
                        'description' => sprintf( esc_html__('Upgrade to %1s in order to change site footer copyright information and hide theme author link via Customizer.', 'wellness'), '<a target="_blank" href="'. wellness_get_premium_url() .'">Wellness Pro</a>' ),
                    )
                )
            );

            $wp_customize->add_setting( 'featured_premium_message',
                array(
                    'sanitize_callback' => 'sanitize_text_field',
                    'default'           => '',
                )
            );
            $wp_customize->add_control( new Wellness_Group_Settings_Heading_Control( $wp_customize, 'featured_premium_message',
                    array(
                        'type'        => 'group_heading_message',
                        'title'       => esc_html__('Change number posts to show', 'wellness'),
                        'section'     => 'featured_content',
                        'description' => sprintf( esc_html__('Upgrade to %1$s to unlock unlimited posts.', 'wellness'), '<a target="_blank" href="'. wellness_get_premium_url() .'">Wellness Pro</a>' ),
                    )
                )
            );

            // Premium sections
            $wp_customize->add_section( new Wellness_Customize_Section_Premium( $wp_customize, 'premium_section_pricing',
                    array(
                        'title'     => esc_html__( 'Front Page: Pricing Tables', 'wellness' ),
                        'priority'  => 65,
                        'panel'     => 'wellness_theme_options',
                        'plus_text' => esc_html__( 'Go Pro', 'wellness' ),
                        'plus_url'  => wellness_get_premium_url()
                    )
                )
            );

            // Premium sections
            $wp_customize->add_section( new Wellness_Customize_Section_Premium( $wp_customize, 'premium_section_team',
                    array(
                        'title'     => esc_html__( 'Front Page: Teams', 'wellness' ),
                        'priority'  => 75,
                        'panel'     => 'wellness_theme_options',
                        'plus_text' => esc_html__( 'Go Pro', 'wellness' ),
                        'plus_url'  => wellness_get_premium_url()
                    )
                )
            );

            $wp_customize->add_section( new Wellness_Customize_Section_Premium( $wp_customize, 'premium_section_orders',
                    array(
                        'title'     => esc_html__( 'Section Orders', 'wellness' ),
                        'priority'  => 15,
                        'panel'     => 'wellness_theme_options',
                        'plus_text' => esc_html__( 'Go Pro', 'wellness' ),
                        'plus_url'  => wellness_get_premium_url()
                    )
                )
            );


            $wp_customize->add_section( 'wellness_premium' ,
                array(
                    'title'       => esc_html__( 'Upgrade to Pro', 'wellness' ),
                    'description' => '',
                    'priority'  => 215,
                )
            );

            $wp_customize->add_setting( 'wellness_premium_features', array(
                'sanitize_callback' => 'sanitize_text_field',
            ) );
            $wp_customize->add_control(
                new Wellness_Group_Settings_Heading_Control(
                    $wp_customize,
                    'wellness_premium_features',
                    array(
                        'label'      => esc_html__( 'Wellness Pro Features', 'wellness' ),
                        'description'   => '<span>Advanced Typography Options</span><span>600+ Google Fonts</span><span>Unlimited Slider Slide</span><span>Sticky Menu</span><span>Team Members Section</span><span>Pricing Tables Section</span><span>Footer Copyright Editor</span><span>Remove Footer Link via Customizer</span><span>... and much more </span>',
                        'section'    => 'wellness_premium',
                        'type'    => 'group_heading_message',
                    )
                )
            );
            $wp_customize->add_setting( 'wellness_premium_links', array(
                'sanitize_callback' => 'sanitize_text_field',
            ) );
            $wp_customize->add_control(
                new Wellness_Group_Settings_Heading_Control(
                    $wp_customize,
                    'wellness_premium_links',
                    array(
                        'description'   => '<a target="_blank" class="wellness-premium-buy-button" href="'.wellness_get_premium_url().'">Buy Wellness Pro Now</a>', 'wellness',
                        'section'    => 'wellness_premium',
                        'type'    => 'group_heading_message',
                    )
                )
            );



         // end if free


}
add_action( 'customize_register', 'wellness_customize_register' );

/**
 * Sanitize the dropdown pages.
 */
function wellness_sanitize_dropdown_pages( $input ) {
	if ( is_numeric( $input ) ) {
		return intval( $input );
	}
}

/**
 * Sanitize the Testimonial Layout on front page.
 */
function wellness_sanitize_front_page_testimonial_layout( $layout ) {
	if ( ! in_array( $layout, array( 'slider', 'grid' ) ) ) {
		$layout = 'slider';
	}
	return $layout;
}

/**
 * Sanitize the Sidebar Position.
 */
function wellness_sanitize_sidebar_position( $position ) {
	if ( ! in_array( $position, array( 'left', 'right' ) ) ) {
		$position = 'right';
	}
	return $position;
}

/**
 * Sanitize callback for 'html' type text inputs. This callback sanitizes `$html` for HTML allowable in posts.
 */
function wellness_sanitize_html( $string ) {
	return wp_filter_post_kses( $string );
}

/**
 * Sanitization callback for 'number' type text inputs. This callback sanitizes `$number`
 * as an absolute integer (whole number, zero or greater).
 */
function wellness_sanitize_number_absint( $number, $setting ) {
	$number = absint( $number );
	return ( $number ? $number : $setting->default );
}


/**
 * Sanitize the text input.
 */
function wellness_sanitize_text( $string ) {
	return wp_kses_post( balanceTags( $string ) );
}

/**
 * Sanitize the checkbox.
 */
function wellness_sanitize_checkbox( $input ) {
	if ( 1 == $input ) {
		return true;
	} else {
		return false;
	}
}

function wellness_is_frontpage() {
    return is_page_template( 'templates/front-page.php' );
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function wellness_customize_preview_js() {
    wp_enqueue_script( 'wellness-customizer-preview', get_template_directory_uri() . '/assets/js/customizer-preview.js', array( 'jquery', 'customize-preview' ), '', true );
    wp_localize_script( 'wellness-customizer-preview', 'wellness_customizer', array(
        'footer_copyright' => sprintf(esc_html__('Copyright %1$s %2$s %3$s. All Rights Reserved.', 'wellness'), '&copy;', date_i18n('Y'), get_bloginfo()),
    ) );
}
add_action( 'customize_preview_init', 'wellness_customize_preview_js' );


function wellness_customize_js_settings(){

    wp_register_script( 'wellness_customizer_controls', get_template_directory_uri() . '/assets/js/customizer-controls.js', array( 'customize-controls' ),  false, true );
    wp_register_style( 'wellness-customizer-controls',  get_template_directory_uri() . '/assets/css/customizer.css' );

    wp_enqueue_script('wellness_customizer_controls');
    wp_enqueue_style('wellness-customizer-controls');


}
add_action( 'customize_controls_enqueue_scripts', 'wellness_customize_js_settings' );
